﻿$(document).ready(function () {

    // Verify for empty first column
    if ($('div.choiceGrid').length > 0) {
        $('table.choiceGrid').each(function () {
            var firstCells = $("tr th:first-child", $(this));
            var hasContent = false;

            firstCells.each(function () {
                if ($(this).html().trim().length > 0) {
                    hasContent = true;
                    return false;
                }
            });

            if (!hasContent) {
                firstCells.remove();
                $(this).find("colgroup.leftLabel").remove();
            }
        });
    }

    $('div.hybridGrid td').on("click", function (args) {
        GridCellClick($(args.target));
    });

    $('div.choiceGrid td, div.netPromoter td').on("click", function (args) {
        GridCellClick($(args.target));
    });
});

function GridCellClick(target) {
    var choice = target.is(".choice") ? target : target.find('.choice');

    if (choice.length > 0 && !choice.hasClass("disabled") && !choice.hasClass("maxDisabled")) {
        if ($("img:visible", choice).length > 0) {
            choice.trigger("click");
        }
        else {
            $(":input:visible", choice).trigger("click");
        }
    }
}